<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'Ledger Account';

        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);
        $s_comp_id = clean_data($_SESSION["comp_id"]);
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");
            $comp_detail_one = find_value('company', 'detail_one', " and comp_id = '$s_comp_id'");
        }


        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 30);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(278, 10, ($comp_detail_one), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(50, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(199, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
#line        $this->Line(11,37,287,37);
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(1);
        $this->Cell(10, 8, 'Ser', 1);
        $this->Cell(15, 8, 'Date', 1, 0, 'C');
        $this->Cell(20, 8, 'Voucher ID', 1, 0, 'C');
        $this->Cell(80, 8, 'Particulars', 1);
        $this->Cell(20, 8, 'Qty', 1, 0,'R');
        $this->Cell(20, 8, 'Rate', 1, 0,'R');
        $this->Cell(20, 8, 'Discount', 1, 0,'R');

        $this->Cell(30, 8, 'Debit', 1, 0,'R');
        $this->Cell(30, 8, 'Credit', 1, 0,'R');
        $this->Cell(30, 8, 'Balance', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

        $comp_id = $_GET['comp_id'];
        $emp_id = clean_data($_SESSION["VALID_USER_ID"]);
        $auth_id = find_value('users', 'auth_id', " and emp_id='$emp_id'");

        
        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $acct_id = clean_data($_GET['acct_id']);

        $and = ' and length(v.acct_id)=10';
        $and_comp = "";

$and_comp = "";
if ($comp_id != "All") {
    $and_comp .= " and v.comp_id = '$comp_id'";
}
else
{
    $and_comp .= " and v.comp_id in(SELECT c.comp_id FROM company c
                        LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                        WHERE uc.emp_id = '$emp_id' )";
}




$and = '';
if ($acct_id != "All") {
    $and .= " and v.acct_id = '$acct_id'";
}

//echo $and;
//$and .= " and v.acct_id in('2610000001','2610000002','2610000003','2610000004')";


try {
    $msqlquery = "SELECT v.acct_id, v.acct_name
FROM
	v_party v
	WHERE 1=1  $and";

    //echo $query;

                $m_result = $dbcon->prepare($msqlquery);
                $m_result->execute();
    }catch(PDOException $e){
        echo "Error : ". $e->getMessage();
}


$sr = "";
            $net_amt_tot = '';
            $disc_amt_tot = '';
            $rec_amt_tot = '';
            $rtn_amt_tot = '';
            $bal_amt_tot = '';
            $g_o_bal = '';

        $no_row = 0;


while($mrow = $m_result->fetch(PDO::FETCH_ASSOC)) {
            $g_acct_id = $mrow['acct_id'];
            $g_acct_name = $mrow['acct_name'];
            $bal = 0;


    try {
        $ob_query = "SELECT
	sum(ifnull(v.debit,0) - ifnull(v.credit,0)) o_bal
	FROM
	v_vouchers v
	WHERE 1=1
	and v.acct_id = '$g_acct_id' and v.voucher_date < '$new_from_date' $and_comp ";
                                //echo $query;
                                                $o_result = $dbcon->prepare($ob_query);
                                                $o_result->execute();
                                            } catch (PDOException $e) {
                                                echo "Error : " . $e->getMessage();
                }
 
            $o_row = $o_result->fetch(PDO::FETCH_ASSOC);

            $bal = $o_row['o_bal'];

            /***************END MYSQL QUERY FOR GROUP OPENING BALANCE*****************/

            ?>

            <?php
    $and = " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

    try {
        $d_query = "SELECT concat(v.comp_id,v.year_id,v.voucher_id) v_id, v.comp_id, v.voucher_id,v.voucher_date, 
                v.cr_amt debit_amount, v.db_amt credit_amount, v.disc_amt, concat(ifnull(v.particulars,''), if(v.particulars is null,'',' / '), ifnull(i.description,'')) particulars, if(ifnull(v.db_qty,0)=0,v.cr_qty, v.db_qty) qty, v.rate, v.stax-v.add_stax stax, v.add_stax
		FROM v_p_vouchers v
		LEFT JOIN v_item i on v.stock_code=i.stock_code
		
		WHERE 1=1
		 AND v.party_id = '$g_acct_id'  $and $and_comp
		 order by v.voucher_date, v.voucher_id, v.lineitem";
//echo   $d_query;

#echo $d_query;
        $d_result = $dbcon->prepare($d_query);
        $d_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

            //echo $query;


   //         $no_row = $d_result->rowCount();
    //$no_row=1;


                        $g_o_bal += $bal;


                $sr += 1;

                    $pdf->Ln(8);
                    $pdf->SetFont('Arial', 'B', 10);
                    $pdf->Cell(1);
                    $pdf->Cell(25, 8, $g_acct_id, 0);
                    $pdf->Cell(20, 8, $g_acct_name, 0);
                    $pdf->Cell(200, 8, 'Opening Balance : ', 0, 0, 'R');
                    $pdf->Cell(30, 8, format_number_drcr($bal,0), 0, 0, 'R');
                    $pdf->SetFont('Arial', '', 8);

                                            

    



                    $serno = 0;
                    $qty_tot = 0;
                    $disc_amt_tot = 0;
                    $debit_amount_tot = 0;
                    $credit_amount_tot = 0;

                    while ($report_row = $d_result->fetch(PDO::FETCH_ASSOC)) {
                        $serno = $serno + 1;
                        $qty_tot += $report_row['qty'];
                        $disc_amt_tot += $report_row['disc_amt'];
                        $debit_amount_tot += $report_row['debit_amount'];
                        $credit_amount_tot += $report_row['credit_amount'];
                        $bal = $bal + $report_row['debit_amount'] - $report_row['credit_amount'];




                        $pdf->Ln(8);
        $pdf->Cell(1);
        $pdf->Cell(10, 8, $serno, 1,'C');
        $pdf->Cell(15, 8, format_date($report_row['voucher_date']), 1, 0, 'C');
        $pdf->Cell(20, 8, $report_row['voucher_id'], 1, 0, 'C');
        $pdf->Cell(80, 8, $report_row['particulars'], 1);
        $pdf->Cell(20, 8, format_number_pdf($report_row['qty'],2), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($report_row['rate'],2), 1, 0,'R');
                        $pdf->Cell(20, 8, format_number_pdf($report_row['discount'],0), 1, 0,'R');

        $pdf->Cell(30, 8, format_number_pdf($report_row['debit_amount'],0), 1, 0,'R');
        $pdf->Cell(30, 8, format_number_pdf($report_row['credit_amount'],0), 1, 0,'R');
        $pdf->Cell(30, 8, format_number_drcr($bal,0), 1, 0,'R');

}


if ($debit_amount_tot<>0 or $credit_amount_tot<>0){
    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(116);
    $pdf->Cell(10, 8, 'Total : ', 0, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($qty_tot,2), 1, 0,'R');
    $pdf->Cell(20, 8, '', 0, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($disc_amt_tot,0), 1, 0,'R');
    $pdf->Cell(30, 8, format_number_pdf($debit_amount_tot,0), 1, 0,'R');
    $pdf->Cell(30, 8, format_number_pdf($credit_amount_tot,0), 1, 0,'R');
    $pdf->Ln(8);
}

}






$pdf->Ln(8);
$pdf->SetFont('Arial', 'B', 16);

$pdf->Cell(40, 8, 'Debit : ', 1, 0,'R');
$pdf->Cell(50, 8, format_number_pdf($debit_amount_tot,0), 1, 0,'L');

$pdf->Cell(40, 8, 'Credit : ', 1, 0,'R');
$pdf->Cell(50, 8, format_number_pdf($credit_amount_tot,0), 1, 0,'L');

$pdf->Cell(40, 8, 'Balance : ', 1, 0,'R');
$pdf->Cell(50, 8, format_number_drcr($bal,0), 1, 0,'L');
$pdf->Ln(8);

$pdf->Output();
ob_end_flush();